/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.util.list;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import cz.insophy.inplan.util.BiPeekingIterator;
import cz.insophy.inplan.util.list.SortedList;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Random;

public final class SkipList<T>
extends AbstractList<T>
implements SortedList<T> {
    private final Random rand;
    private Node<T> head;
    private Node<T> tail;
    private int height;
    private int size;
    private final Comparator<T> comparator;
    private Node<T>[] path;

    public SkipList(Comparator<T> comparator, Random rand) {
        this.comparator = comparator;
        this.rand = rand;
        this.init();
    }

    private void init() {
        this.size = 0;
        this.height = 2;
        this.head = new Node(this.height);
        this.tail = new Node(-1);
        this.head.next = this.tail;
        this.tail.prev = this.head;
        this.path = new Node[this.height + 1];
        ++this.modCount;
    }

    private void updateHeight(int newHeight) {
        if (newHeight <= this.height) {
            return;
        }
        Node[] newHeadNexts = new Node[newHeight + 1];
        System.arraycopy(this.head.nexts, 0, newHeadNexts, 0, this.head.nexts.length);
        Node[] newPath = new Node[newHeight + 1];
        for (int i = 0; i <= newHeight; ++i) {
            newPath[i] = i <= this.height ? this.path[i] : this.head;
        }
        this.path = newPath;
        this.head.nexts = newHeadNexts;
        this.height = newHeight;
    }

    private int randomLevel() {
        int i;
        for (i = -1; i < this.height && this.rand.nextInt(2) == 1; ++i) {
            int sb;
            if (i != this.height - 1 || (sb = SkipList.highestBitSet(this.size) - 1) <= this.height) continue;
            this.updateHeight(sb);
        }
        return i;
    }

    @VisibleForTesting
    static int highestBitSet(int v) {
        int r = 0;
        while ((v >>= 1) != 0) {
            ++r;
        }
        return r;
    }

    @Override
    public boolean add(T value) {
        int cmp;
        ++this.size;
        Node<T> n = this.head;
        for (int i = this.height; i >= 0; --i) {
            while (n.nexts[i] != null && this.comparator.compare(value, n.nexts[i].value) > 0) {
                n = n.nexts[i];
            }
            this.path[i] = n;
        }
        n = n.next;
        int lastCmp = 42;
        while (n != this.tail && (cmp = this.comparator.compare(value, n.value)) >= 0) {
            n = n.next;
            lastCmp = cmp;
        }
        n = n.prev;
        int level = lastCmp == 0 ? -1 : this.randomLevel();
        Node newNode = new Node(level);
        newNode.value = value;
        newNode.next = n.next;
        newNode.prev = n;
        n.next = newNode;
        newNode.next.prev = newNode;
        for (int i = 0; i <= level; ++i) {
            newNode.nexts[i] = this.path[i].nexts[i];
            this.path[i].nexts[i] = newNode;
        }
        ++this.modCount;
        return true;
    }

    private void removeNode(Node<T> n) {
        --this.size;
        n.prev.next = n.next;
        n.next.prev = n.prev;
        for (int i = 0; i <= n.getLevel(); ++i) {
            this.path[i].nexts[i] = n.nexts[i];
        }
        ++this.modCount;
    }

    @Override
    public boolean remove(Object obj) {
        Object value = obj;
        Node<T> n = this.head;
        for (int i = this.height; i >= 0; --i) {
            while (n.nexts[i] != null && this.comparator.compare(value, n.nexts[i].value) > 0) {
                n = n.nexts[i];
            }
            this.path[i] = n;
        }
        n = n.next;
        while (n != this.tail && this.comparator.compare(value, n.value) > 0) {
            n = n.next;
        }
        if (n == this.tail) {
            return false;
        }
        boolean eq = false;
        while (n != this.tail && this.comparator.compare(value, n.value) == 0 && !(eq = n.value.equals(obj))) {
            n = n.next;
        }
        if (eq) {
            this.removeNode(n);
        }
        return eq;
    }

    @VisibleForTesting
    Iterable<Node<T>> nodes() {
        return new Iterable<Node<T>>(){

            @Override
            public Iterator<Node<T>> iterator() {
                return new NodeIter();
            }
        };
    }

    @VisibleForTesting
    Iterable<Node<T>> nodeLevel(final int level) {
        return new Iterable<Node<T>>(){

            @Override
            public Iterator<Node<T>> iterator() {
                return new NodeLevelIter(level);
            }
        };
    }

    @VisibleForTesting
    int getHeight() {
        return this.height;
    }

    public static <T> SkipList<T> create(Comparator<T> comparator) {
        return new SkipList<T>(comparator, new Random());
    }

    @VisibleForTesting
    public static <T> SkipList<T> create(Comparator<T> comparator, Random rand) {
        return new SkipList<T>(comparator, new Random());
    }

    private Node<T> nthNode(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        Node n = this.head.next;
        for (int i = 0; i < index; ++i) {
            n = n.next;
        }
        return n;
    }

    private Node<T> nextNodeOf(T value) {
        Node<T> n = this.head;
        for (int i = this.height; i >= 0; --i) {
            while (n.nexts[i] != null && this.comparator.compare(value, n.nexts[i].value) > 0) {
                n = n.nexts[i];
            }
        }
        while ((n = n.next) != this.tail && this.comparator.compare(value, n.value) > 0) {
        }
        return n;
    }

    @Override
    public T nextOf(T value) {
        Node<T> n = this.nextNodeOf(value);
        return n.value;
    }

    @Override
    public T previousOf(T value) {
        Node<T> n = this.nextNodeOf(value);
        while ((n = n.prev) != this.head && this.comparator.compare(value, n.value) < 0) {
        }
        return n.value;
    }

    @Override
    public BiPeekingIterator<T> iterator(T from) {
        Node<T> n = this.nextNodeOf(from);
        n = n.prev;
        return new ValueIter(n);
    }

    @Override
    public Iterator<T> iterator() {
        return new ValueIter(this.head);
    }

    @Override
    public T get(int index) {
        return this.nthNode((int)index).value;
    }

    @Override
    public T remove(int index) {
        Node<T> n = this.nthNode(index);
        this.removeNode(n);
        return n.value;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.init();
    }

    @VisibleForTesting
    static final class Node<T> {
        Node<T> next;
        Node<T> prev;
        Node<T>[] nexts;
        T value;

        public Node(int level) {
            if (level >= 0) {
                this.nexts = new Node[level + 1];
            }
        }

        public int getLevel() {
            return this.nexts == null ? -1 : this.nexts.length - 1;
        }

        public String toString() {
            return this.value + "(" + this.getLevel() + ")";
        }
    }

    private class ValueIter
    implements BiPeekingIterator<T> {
        private Node<T> current;
        private boolean removeOk;
        private int expectedModCount;

        public ValueIter(Node<T> start) {
            this.current = start;
            this.removeOk = false;
            this.expectedModCount = SkipList.this.modCount;
        }

        @Override
        public boolean hasNext() {
            return this.current.next != SkipList.this.tail;
        }

        @Override
        public T next() {
            this.checkForComodification();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.removeOk = true;
            this.current = this.current.next;
            return this.current.value;
        }

        @Override
        public void remove() {
            if (!this.removeOk) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            this.removeOk = false;
            SkipList.this.removeNode(this.current);
            this.current = this.current.prev;
            this.expectedModCount = SkipList.this.modCount;
        }

        @Override
        public boolean hasPrevious() {
            return this.current != SkipList.this.head;
        }

        @Override
        public T previous() {
            this.checkForComodification();
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.current = this.current.prev;
            return this.current.next.value;
        }

        @Override
        public T peekPrevious() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            return this.current.value;
        }

        @Override
        public T peekNext() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.current.next.value;
        }

        private final void checkForComodification() {
            if (SkipList.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private class NodeLevelIter
    implements Iterator<Node<T>> {
        Node<T> current;
        private final int level;

        public NodeLevelIter(int level) {
            this.current = SkipList.this.head;
            Preconditions.checkArgument(level >= 0 && level < SkipList.this.height);
            this.level = level;
        }

        @Override
        public boolean hasNext() {
            return this.current.nexts[this.level] != null;
        }

        @Override
        public Node<T> next() {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            this.current = this.current.nexts[this.level];
            return this.current;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class NodeIter
    implements Iterator<Node<T>> {
        Node<T> current;

        private NodeIter() {
            this.current = SkipList.this.head;
        }

        @Override
        public boolean hasNext() {
            return this.current.next != SkipList.this.tail;
        }

        @Override
        public Node<T> next() {
            this.current = this.current.next;
            return this.current;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

